# dumps an entity based on number, won't dump entity 0 (worldspawn)
# Version 2.0 by Zoner
#
# This file is a script, which requires a version of Perl to be installed so it may function.
#
# A Windows version of Perl can be obtained at http://www.activestate.com
#

sub Usage
{
    print STDOUT <<__FOO__
dumpent.pl Usage:

perl dumpent.pl <entity> <mapname>

This script will not dump entity zero, aka 'The Worldspawn' as it
typically has hundreds or thousands of brushes inside it.

__FOO__
;
    exit 0;
}

sub main
{
    local $entity_to_find = $ARGV[0];
    local $file = $ARGV[1];

    local $state = -1;
    local $entitynum = -1;

    local $printed_something = 0;

    $file =~ s/\.map//i;

    $_ = $ARGV[0];
    if (($ARGV[0] eq "") || (/(\?|help)/i))
    {
        Usage();
    }

    if ($entity_to_find <= 0)
    {
        Usage();
    }

    open(OLD, "<$file.map")         or die "can't open $file: $!";

    while (<OLD>)
    {
        if (/{\s/)
        {
            $state++;
            if ($state == 0)
            {
                $entitynum++;
            }
        }
        if (/}\s/)
        {
            $state--;
        }
        if ($entitynum == $entity_to_find)
        {
            $printed_something++;
            print $_;
        }
    }

    close(OLD);

    if ($printed_something == 0)
    {
        print "Entity[$entity_to_find] not found in $file\n";
    }
}

&main;
